# A1Tabs - 智能标签页管理Chrome插件

基于需求文档开发的Chrome浏览器插件，帮助用户高效管理和组织浏览器标签页。

## 🚀 功能特性

- **动态链接管理** - 添加、编辑、删除链接
- **标签分类系统** - 支持自定义分类和颜色标识
- **个性化Logo** - 支持汉字或英文字母标识
- **快速搜索** - 按标题、URL、分类搜索
- **右键快速添加** - 网页右键菜单快速添加链接
- **访问统计** - 记录链接访问次数和时间
- **数据同步** - Chrome账户同步数据

## 📦 项目结构

```
A1Tabs/
├── manifest.json                 # Chrome插件清单文件
├── popup.html                   # 弹窗界面HTML
├── package.json                 # 项目配置文件
├── README.md                   # 项目说明文档
├── 需求分析.md                  # 详细需求文档
├── src/                        # 源代码目录
│   ├── background/             # 后台脚本
│   │   └── background.js      # Service Worker
│   ├── content/               # 内容脚本
│   │   └── content.js        # 页面注入脚本
│   ├── js/                   # JavaScript文件
│   │   ├── popup.js          # 弹窗主逻辑
│   │   ├── utils/            # 工具函数
│   │   │   ├── storage.js    # 存储管理
│   │   │   └── helpers.js    # 辅助函数
│   │   └── components/       # UI组件
│   │       ├── LinkCard.js   # 链接卡片
│   │       ├── CategoryTab.js # 分类标签
│   │       └── Modal.js      # 模态框
│   └── styles/               # 样式文件
│       ├── popup.css        # 主样式
│       └── components.css   # 组件样式
└── assets/                  # 静态资源
    └── icons/              # 图标文件
        ├── icon16.png
        ├── icon32.png
        ├── icon48.png
        └── icon128.png
```

## 🛠️ 开发指南

### 环境要求
- Chrome浏览器 88+
- Node.js 16+（可选，用于开发工具）

### 安装步骤

1. **下载项目**
   ```bash
   git clone https://github.com/yourusername/a1tabs.git
   cd a1tabs
   ```

2. **安装依赖**（可选）
   ```bash
   npm install
   ```

3. **加载插件**
   - 打开Chrome浏览器
   - 进入扩展程序管理页面 (chrome://extensions/)
   - 开启"开发者模式"
   - 点击"加载已解压的扩展程序"
   - 选择A1Tabs项目根目录

### 开发调试

- **查看日志**: F12开发者工具Console面板
- **调试弹窗**: 右键插件图标 → 检查弹出内容
- **调试后台**: 扩展程序页面 → 检查视图 → Service Worker

## 📋 使用说明

### 基本操作

1. **添加链接**
   - 点击插件图标打开面板
   - 点击"+"按钮添加链接
   - 填写链接信息并保存

2. **分类管理**
   - 在分类栏中切换不同分类
   - 点击"+"添加新分类
   - 拖拽链接到不同分类

3. **快速添加**
   - 右键网页 → "添加到A1Tabs"
   - 快捷键 Ctrl+Shift+T 打开面板

### 高级功能

- **搜索**: 顶部搜索框支持标题、URL、分类搜索
- **批量操作**: 长按Ctrl键多选链接
- **数据备份**: 设置中可导出/导入数据

## 🔧 技术架构

- **前端**: HTML5, CSS3, JavaScript (ES6+)
- **存储**: Chrome Storage API (同步存储)
- **权限**: tabs, storage, contextMenus, bookmarks
- **架构**: Manifest V3 规范

## 📝 更新日志

### v1.0.0 (2025-01-01)
- ✨ 初始版本发布
- 🚀 基础链接管理功能
- 🎨 现代化UI设计
- 📱 响应式布局支持

## 🤝 贡献指南

1. Fork项目
2. 创建功能分支 (`git checkout -b feature/AmazingFeature`)
3. 提交更改 (`git commit -m 'Add some AmazingFeature'`)
4. 推送到分支 (`git push origin feature/AmazingFeature`)
5. 创建Pull Request

## 📄 许可证

本项目基于MIT许可证开源 - 详见 [LICENSE](LICENSE) 文件

## 🙋‍♂️ 支持

如有问题或建议，请提交[Issue](https://github.com/yourusername/a1tabs/issues)

---

**A1Tabs** - 让标签页管理更简单高效 🚀