// 分类标签组件
const CategoryTab = {
  create(categoryData) {
    const { id, name, color, icon, linkCount, isActive } = categoryData;
    
    const tab = document.createElement('div');
    tab.className = `category-tab ${isActive ? 'active' : ''}`;
    tab.setAttribute('data-category-id', id);
    
    // 构建HTML内容
    let innerHTML = '';
    
    // 如果有图标，显示图标，否则显示默认图标
    const displayIcon = icon && icon.trim() ? icon : '📁';
    innerHTML += `<span class="category-icon">${displayIcon}</span>`;
    
    innerHTML += `<span class="category-name">${name}</span>`;
    
    // 如果有链接数量，显示计数
    if (typeof linkCount === 'number' && linkCount > 0) {
      innerHTML += `<span class="category-count">${linkCount}</span>`;
    }
    
    innerHTML += `<span class="category-indicator" style="background-color: ${color}"></span>`;
    
    // 删除按钮已移至管理分类功能中
    
    tab.innerHTML = innerHTML;
    
    return tab;
  },
  
  // 更新分类标签的链接数量
  updateCount(categoryId, count) {
    const tab = document.querySelector(`[data-category-id="${categoryId}"]`);
    if (tab) {
      const countElement = tab.querySelector('.category-count');
      
      if (countElement) {
        countElement.textContent = count;
      } else if (count > 0) {
        // 如果之前没有计数元素，创建一个
        const countSpan = document.createElement('span');
        countSpan.className = 'category-count';
        countSpan.textContent = count;
        
        const indicator = tab.querySelector('.category-indicator');
        indicator.parentNode.insertBefore(countSpan, indicator);
      }
    }
  }
};
