// 链接卡片组件
const LinkCard = {
  create(linkData) {
    const { id, title, url, logo, categoryName, categoryColor, visitCount, createTime } = linkData;
    
    const card = document.createElement('div');
    card.className = 'link-card';
    card.setAttribute('data-link-id', id);
    
    card.innerHTML = `
      <div class="link-card-header">
        <div class="link-logo" style="background-color: ${linkData.logoColor || categoryColor || '#4285f4'}">
          ${logo || '?'}
        </div>
        <div class="link-actions">
          <button class="link-action-btn" data-action="edit" title="编辑">
            <svg class="icon" viewBox="0 0 24 24">
              <path d="M20.71,7.04C21.1,6.65 21.1,6 20.71,5.63L18.37,3.29C18,2.9 17.35,2.9 16.96,3.29L15.12,5.12L18.87,8.87M3,17.25V21H6.75L17.81,9.93L14.06,6.18L3,17.25Z"/>
            </svg>
          </button>
          <button class="link-action-btn" data-action="delete" title="删除">×</button>
        </div>
      </div>
      <div class="link-card-body">
        <h3 class="link-title">${TextUtils.truncate(title, 50)}</h3>
        <div class="link-meta">
          <span class="link-domain">${extractDomain(url)}</span>
          ${visitCount > 0 ? `<span class="visit-count">${visitCount} 次访问</span>` : ''}
        </div>
      </div>
      <div class="link-card-footer">
        ${categoryName ? `<div class="link-category">${categoryName}</div>` : ''}
        <div class="link-time">${getRelativeTime(createTime)}</div>
      </div>
    `;
    
    this.bindEvents(card, linkData);
    return card;
  },
  
  bindEvents(cardElement, linkData) {
    cardElement.addEventListener('click', (e) => {
      if (e.target.closest('.link-action-btn')) return;
      this.openLink(linkData.url, linkData.id);
    });
    
    const editBtn = cardElement.querySelector('[data-action="edit"]');
    editBtn.addEventListener('click', (e) => {
      e.stopPropagation();
      this.editLink(linkData);
    });
    
    const deleteBtn = cardElement.querySelector('[data-action="delete"]');
    deleteBtn.addEventListener('click', (e) => {
      e.stopPropagation();
      this.deleteLink(linkData.id, linkData.title);
    });
  },
  
  async openLink(url, linkId) {
    try {
      await chrome.runtime.sendMessage({ action: 'openLink', url });
      window.close();
    } catch (error) {
      console.error('Failed to open link:', error);
    }
  },
  
  async deleteLink(linkId, linkTitle) {
    // 使用模态框确认删除
    Modal.showDeleteLinkModal(linkId, linkTitle);
  },
  
  editLink(linkData) {
    // 打开编辑链接模态框
    Modal.showEditLinkModal(linkData);
  }
};